<?php
require 'vendor/autoload.php'; // include PhpSpreadsheet and PHPMailer

use PhpOffice\PhpSpreadsheet\IOFactory;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Load Excel file
$spreadsheet = IOFactory::load('invoice_reminders_template.xlsx');
$sheet = $spreadsheet->getActiveSheet();
$rows = $sheet->toArray(null, true, true, true);

// Loop through rows (skip header)
foreach ($rows as $i => $row) {
    if ($i == 1) continue; // skip header

    $clientEmail = $row['D'];
    $clientName = $row['C'];
    $invoiceDesc = $row['B'];
    $amount = $row['E'];
    $daysPastDue = $row['G'];
    $reminder30 = $row['H'];
    $reminder60 = $row['I'];
    $reminder90 = $row['J'];

    // Check if any reminder is needed
    if (in_array("Send Reminder", [$reminder30, $reminder60, $reminder90])) {
        $mail = new PHPMailer(true);
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'smtp.yourdomain.com'; // Replace with your SMTP
            $mail->SMTPAuth = true;
            $mail->Username = 'your@email.com';
            $mail->Password = 'yourpassword';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            // Email content
            $mail->setFrom('your@email.com', 'Finance Team');
            $mail->addAddress($clientEmail, $clientName);
            $mail->Subject = "Invoice Reminder - $daysPastDue Days Overdue";
            $mail->Body = "Dear $clientName,\n\nThis is a reminder that your invoice ('$invoiceDesc') for ₹$amount is $daysPastDue days overdue.\n\nPlease arrange payment soon.\n\nRegards,\nFinance Team";

            $mail->send();
            echo "Reminder sent to $clientEmail<br>";
        } catch (Exception $e) {
            echo "Failed to send email to $clientEmail. Error: {$mail->ErrorInfo}<br>";
        }
    }
}
